
/*:

@target MZ
@plugindesc タイマーに機能を追加します。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_TimerAddFunction.js

タイマーに機能を追加します。
カウントアップは59:59までカウントできます。


@command count
@text タイマーのカウント方法変更
@desc タイマーのカウント方法を変更します。

@arg countType
@text カウント方法
@desc タイマーのカウント方法を変更します。
@type select
@option カウントアップ
@option カウントダウン
@default カウントアップ

@command display
@text タイマーの表示を変更
@desc タイマーの表示を変更します。

@arg visible
@text タイマーの表示
@desc タイマーの表示を変更します。
@type boolean
@on 表示
@off 非表示
@default true

@command pause
@text カウントの一時停止を変更
@desc カウントの一時停止を変更します。

@arg pause
@text 一時停止
@desc カウントの一時停止を変更します。
@type boolean
@on 一時停止にする
@off 一時停止にしない
@default true

*/

(() => {
    
    /////////////////プラグイン関係/////////////////
    
    const pluginName = "MK_TimerAddFunction";
    
    //----------プラグインコマンド----------
    
    //タイマーのカウント方法変更
    PluginManager.registerCommand(pluginName, "count", args => {
        $gameTimer.MK_TimerAddFunction_CountUp((args.countType == "カウントアップ") ? true : false);
    });
    
    //タイマーの表示を変更
    PluginManager.registerCommand(pluginName, "display", args => {
        $gameTimer.MK_TimerAddFunction_Display((args.visible == "true") ? true : false);
    });
    
    //カウントの一時停止を変更
    PluginManager.registerCommand(pluginName, "pause", args => {
        $gameTimer.MK_TimerAddFunction_Pause((args.pause == "true") ? true : false);
    });
    
    
    /////////////////元々オブジェクト/////////////////
    
    //----------オブジェクト関係----------
    
    const _Game_Timer_initialize = Game_Timer.prototype.initialize;
    Game_Timer.prototype.initialize = function() {
        _Game_Timer_initialize.apply(this, arguments);
        
        this.mk_timerAddFunction_countUp = false;//カウントアップするか
        this.mk_timerAddFunction_display = true;//時間を表示するか
        this.mk_timerAddFunction_pause = false;//カウント一時停止するか
    };

    const _Game_Timer_update = Game_Timer.prototype.update;
    Game_Timer.prototype.update = function(sceneActive) {
        if(!this.mk_timerAddFunction_pause){
            if(this.mk_timerAddFunction_countUp){
                if (sceneActive && this._working && this._frames < 215940) {
                    this._frames++;
                    if (this._frames === 215940) {
                        this.onExpire();
                    }
                }
            }else{
                _Game_Timer_update.apply(this, arguments);
            }
        }
    };
    
    //タイマーのカウント方法をカウントアップにするか
    Game_Timer.prototype.MK_TimerAddFunction_CountUp = function(countUp) {//trueかfalse
        this.mk_timerAddFunction_countUp = countUp;
    };

    //タイマー表示させるか
    Game_Timer.prototype.MK_TimerAddFunction_Display = function(display) {//trueかfalse
        this.mk_timerAddFunction_display = display;
    };
    
    //カウントを一時停止にするか
    Game_Timer.prototype.MK_TimerAddFunction_Pause = function(pause) {//trueかfalse
        this.mk_timerAddFunction_pause = pause;
    };
    
    //----------スプライト関係----------

    const _Sprite_Timer_initialize = Sprite_Timer.prototype.initialize;
    Sprite_Timer.prototype.initialize = function() {
        this.mk_timerAddFunction_display = true;//時間を表示するか
        
        _Sprite_Timer_initialize.apply(this, arguments);
        this._seconds = -1;
    };
    
    const _Sprite_Timer_updateBitmap = Sprite_Timer.prototype.updateBitmap;
    Sprite_Timer.prototype.updateBitmap = function() {
        if(this.mk_timerAddFunction_display && $gameTimer.mk_timerAddFunction_display){
            _Sprite_Timer_updateBitmap.apply(this, arguments);
        }else if(!this.mk_timerAddFunction_display && $gameTimer.mk_timerAddFunction_display){
            _Sprite_Timer_updateBitmap.apply(this, arguments);
            this.mk_timerAddFunction_display = true;
        }else if(this.mk_timerAddFunction_display && !$gameTimer.mk_timerAddFunction_display){
            this.bitmap.clear();
            this.mk_timerAddFunction_display = false;
        }
    };
    
})();
